#include "fx2.h"
#include "fx2regs.h"
#include "eeprom.h"

void EEPROMSetupAddresses()
{
    // Determine I2C boot eeprom device address; addr = 0x0 for 8 bit addr eeproms (24LC00)
    I2C_Addr = SERIAL_ADDR | ((I2CS & 0x10) >> 4); // addr=0x01 for 16 bit addr eeprom (LC65)
    // Indicate if it is a dual byte address part
    DB_Addr = (BOOL)(I2C_Addr & 0x01); // ID1 is 16 bit addr bit - set by rocker sw or jumper
}

///////////////////////////////////////////////////////////////////////////////////////

// Write up to one page of data to the EEPROM.
// Returns 0 on success, 1 on failure
// Normally called within a while() loop so that errors are retried:
// while (EEPROMWritePage(....))
//    ;
// retval removed for simplicity as no need for enable / disable eeprom write protect
bit EEPROMWritePage(BYTE MSaddr, BYTE LSaddr, BYTE xdata * ptr, BYTE len)
{
    BYTE		i;
//    bit      retval;

//    EEPROM_DISABLE_WRITE_PROTECT();

	EEPROMSetupAddresses();
    // Make sure the i2c interface is idle
    EEWaitForStop();
    
    // write the START bit and i2c device address
    EEStartAndAddr();
    
    if(EEWaitForAck())
    {
		return 1;
//        retval = 1;
//        goto EXIT_WP;
    }

    // write the eeprom offset
    if (DB_Addr)
    {
        I2DAT = MSaddr;
        if(EEWaitForAck())
        {
			return 1;
//            retval = 1;
//            goto EXIT_WP;
        }
    }
    I2DAT = LSaddr;
    if(EEWaitForAck())
    {
 		return 1;
//       retval = 1;
//        goto EXIT_WP;
    }

    // Write the data Page
    for (i = 0; i < len; i++)
    {
        I2DAT = *ptr++;
        if(EEWaitForDone())
        {
			return 1;
//            retval = 1;
//            goto EXIT_WP;
        }
    }	
    I2CS |= bmSTOP;
    WaitForEEPROMWrite();

//    retval = 0;

//EXIT_WP:            
//    EEPROM_ENABLE_WRITE_PROTECT();
//    return(retval);
	return 0;
}

void EEStartAndAddr()
{
      I2CS = bmSTART;
      I2DAT = I2C_Addr << 1;
}

// 0x2e in assembly, less than 0x20 with compiler optimization!!
void WaitForEEPROMWrite()
{
   EEWaitForStop();
waitForBusy:
	EEStartAndAddr();

   EEWaitForDone();
   I2CS |= bmSTOP;	//	; Set the STOP bit
   EEWaitForStop();

   if (!(I2CS & bmACK))  // If no ACK, try again.
      goto waitForBusy;
}

void EEWaitForStop()
{
   // Data should not be written to I2CS or I2DAT until the STOP bit returns low.
   while (I2CS & bmSTOP)
      ;
}

// Returns 0 on success, 1 on failure
bit EEPROMRead(BYTE MSaddr, BYTE LSaddr, BYTE length, BYTE xdata *buf)
{
   BYTE i;

   EEPROMSetupAddresses();

   // Make sure the i2c interface is idle
   EEWaitForStop();
   
   // write the START bit and i2c device address
   EEStartAndAddr();

   if(EEWaitForAck())
      return(1);

   // write the eeprom offset
   if (DB_Addr)
      {
      I2DAT = MSaddr;
      if(EEWaitForAck())
         return(1);
      }
   I2DAT = LSaddr;
   if(EEWaitForAck())
      return(1);

   I2CS = bmSTART;

   // send the read command
   I2DAT = (I2C_Addr << 1) | 1;
   if(EEWaitForDone())
      return(1);

   // read dummy byte
   i = I2DAT;
   if(EEWaitForDone())
      return(1);

   for (i=0; i < (length - 1); i++)
   {
      *(buf+i) = I2DAT;
      if(EEWaitForDone())
         return(1);
   }
   
   I2CS = bmLASTRD;
   if(EEWaitForDone())
      return(1);

   *(buf+i) = I2DAT;
   if(EEWaitForDone())
      return(1);

   I2CS = bmSTOP;

   i = I2DAT;
   return(0);
}

// Return 0 for ok, 1 for error
bit EEWaitForDone()
{
   BYTE i;

   while (!((i = I2CS) & 1))  // Poll the done bit
      ;
   if (i & bmBERR)
      return 1;
   else
      return 0;
}

// Return 0 for ok, 1 for error
// Same as wait for done, but checks for ACK as well
bit EEWaitForAck()
{
   BYTE i;

   while (!((i = I2CS) & 1))  // Poll the done bit
      ;
   if (i & bmBERR)
      return 1;
   else if (!(i & bmACK))
      return 1;
   else
      return 0;
}

